/* --------------------------------------------------------------
  FrameToggle.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Application Frame Toggle
 *
 * This class will handle all the possible functionality of the app frame handle. In the
 * future more options might be added like "move the frame to the left side" of the page.
 */
export default class FrameToggle {
	/**
	 * Class Constructor 
	 * 
	 * @param {jQuery} $frame The whole app frame selector.
	 * @param {jQuery} $handle The toggle handle selector.
	 */
	constructor($frame, $handle) {
		StyleEdit.Validator.isObject($frame);
		StyleEdit.Validator.isObject($handle);
		
		/**
		 * App Frame Selector
		 *
		 * @type {jQuery}
		 */
		this.$frame = $frame;
		
		/**
		 * Frame Toggle Handle Selector
		 *
		 * @type {jQuery}
		 */
		this.$handle = $handle;
	}
	
	/**
	 * Initialize the widget.
	 *
	 * This method will bind the required event handlers to the DOM.
	 */
	initialize() {
		this.$handle.on('click', () => {
			if (this.$frame.hasClass('open')) { // then close it
				this.$frame.animate({right: '-320px'}, 300, 'linear', () => {
					this.$frame.removeClass('open').addClass('closed');
					this.$handle.find('.fa-caret-right').hide();
					this.$handle.find('.fa-caret-left').show();
				});
			} else { // was closed so open it
				this.$frame.animate({right: '0'}, 300, 'linear', () => {
					this.$frame.removeClass('closed').addClass('open');
					this.$handle.find('.fa-caret-right').show();
					this.$handle.find('.fa-caret-left').hide();
				});
			}
		});
	}
}